#include <iostream>
#include <cstdlib>
#include <cmath>
#include "snaps.h"
#include "mseid.h"
#include "mecon.h"
#include "mcntl.h"
#include "mfile_open.h"
#include "option.h"

double round( double a , int n );
double pension_marume( int nendo ,int marume_nendo ,double a );
double kaiteiritu_marume( int nendo ,int marume_nendo , double a);
 
void econ_read(FILE *fp , double cpi_up[] , double base_up[]);
void index_make(double base_up[] , double cpi_up[] , double base_up_index[] , double cpi_up_index[] , int marume_nendo);

double honrai_kaiteiritu_make(int nenrei , double base_up_index , double cpi_up_index);
double honrai_kaiteiritu_make_before(int nenrei , double base_up_index , double cpi_up_index);

double tokurei_kaiteiritu_make(int nendo);

int kaishou_check(int nendo , int nenrei , int kaishou_nendo  , double full_pension_honrai , double full_pension_tokurei);

double marume_hantei(int nendo , int marume_nendo , int marume_saishu_nendo ,double pension);



void index_out( FILE *fp ,double cpi_up[] , double base_up[] , double cpi_up_index[] ,double base_up_index[] ,
double kaiteiritu_honrai[][MAX_ROREI_JUKYU - UNDER_67 + 1], double kaiteiritu_tokurei[][MAX_ROREI_JUKYU - UNDER_67 + 1]);
void kaitei_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU - UNDER_67 + 1], int shonendo , int array_shonendo , int saishunendo , char *title );
void rslt_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU - UNDER_67 + 1] , int shonendo , int array_shonendo , int saishunendo ); 
void kakyu_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU + 1], int shonendo , int array_shonendo , int saishunendo , char *title );
void ichijikin_out( FILE *fp , double shibou[][SHIBOU_KUBUN] , int shonendo , int array_shonendo , int saishunendo , char *title);


using namespace std;


void econ()
{

	int CAL_START = 2004;
	int TOKUREI_KAISHOU_NENDO = 2015;
        int MARUME_NENDO = 2019;
	double TOKUREI_START = 0.988;
	
	int nendo;
	int nenrei;
	int kubun;

	int marume_saishu_nendo[MAX_ROREI_JUKYU - UNDER_67 + 1];

	double cpi_up[SAISHUNENDO - ECON_SHONENDO + 1];
	double base_up[SAISHUNENDO - ECON_SHONENDO + 1];

	double base_up_index[SAISHUNENDO - ECON_SHONENDO + 1];
	double cpi_up_index[SAISHUNENDO - ECON_SHONENDO + 1];

	double kaiteiritu_honrai[SAISHUNENDO - ECON_SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];
	double kaiteiritu_honrai_ruiseki[SAISHUNENDO - ECON_SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];

	double kaiteiritu_tokurei[SAISHUNENDO - ECON_SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];
	double kaiteiritu_tokurei_ruiseki[SAISHUNENDO - ECON_SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];


	double kaiteiritu_ruiseki[SAISHUNENDO - ECON_SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];

	double Full_Pension_Honrai[SAISHUNENDO - SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];
	double Full_Pension_Tokurei[SAISHUNENDO - SHONENDO + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];

	double Full_Pension_Honrai_old[2014 - 2005 + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];
	double Full_Pension_Tokurei_old[2014 - 2005 + 1][MAX_ROREI_JUKYU - UNDER_67 + 1];

	double Pension_Temp;
	double Tanka_12shi;
	double Tanka_3shiiko;	

	int TINSURA_NENDO = TINSURA_KAISHI;

	econ_read(fp_in[KEIZAI] , cpi_up , base_up);	

	index_make( base_up , cpi_up , base_up_index , cpi_up_index , MARUME_NENDO);

	nendo = CAL_START;

	for( nenrei = UNDER_67 ; nenrei<= MAX_ROREI_JUKYU ; nenrei++)
	{
		kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 1.;
		kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 1.;
	}		

	for(nendo = CAL_START + 1 ; nendo <= SAISHUNENDO ; nendo++)
	{
		for( nenrei = UNDER_67 ; nenrei<= MAX_ROREI_JUKYU ; nenrei++)
		{
			if( TINSURA == 1){
				if(nendo < TINSURA_NENDO)
				{
					kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67]
					 = honrai_kaiteiritu_make_before( nenrei , base_up_index[nendo - ECON_SHONENDO], cpi_up_index[nendo - ECON_SHONENDO]);
				}
				else
				{
					kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67]
					 = honrai_kaiteiritu_make( nenrei , base_up_index[nendo - ECON_SHONENDO], cpi_up_index[nendo - ECON_SHONENDO]);
				}
			}
			else
			{
				kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67]
				 = honrai_kaiteiritu_make_before( nenrei , base_up_index[nendo - ECON_SHONENDO], cpi_up_index[nendo - ECON_SHONENDO]);
			}
			if(nendo == 2015)
			{
				kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]  
				 = kaiteiritu_marume( nendo , MARUME_NENDO ,
				   kaiteiritu_honrai_ruiseki[nendo - 1 - ECON_SHONENDO][max(nenrei - 1 - UNDER_67 , 0 )] * kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67] * 0.991 );
			}
			else
			{
				kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]  
				 = kaiteiritu_marume( nendo , MARUME_NENDO ,
				   kaiteiritu_honrai_ruiseki[nendo - 1 - ECON_SHONENDO][max(nenrei - 1 - UNDER_67 , 0 )] * kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67]);
			}
		}	
	}

	nendo = CAL_START;

	for( nenrei = UNDER_67 ; nenrei<= MAX_ROREI_JUKYU ; nenrei++)
	{
		kaiteiritu_tokurei[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 1.;
		kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] = TOKUREI_START;
	}

	for(nendo = CAL_START + 1 ; nendo <= SAISHUNENDO ; nendo++)
	{	
		for( nenrei = UNDER_67 ; nenrei<= MAX_ROREI_JUKYU ; nenrei++)
		{
			if(nendo < TOKUREI_KAISHOU_NENDO)
			{
				kaiteiritu_tokurei[nendo - ECON_SHONENDO][nenrei - UNDER_67] = tokurei_kaiteiritu_make( nendo );
			}
			else
			{
				kaiteiritu_tokurei[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 0.;
			}
	
			kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]
			 = kaiteiritu_marume( nendo , MARUME_NENDO , 
		  	   kaiteiritu_tokurei_ruiseki[nendo - 1 - ECON_SHONENDO][max( nenrei - 1 - UNDER_67 ,0)] * kaiteiritu_tokurei[nendo - ECON_SHONENDO][nenrei - UNDER_67] );
		}
	}

	for( nendo = CAL_START + 1 ; nendo < SHONENDO ; nendo++ )
	{
		for( nenrei = UNDER_67 ; nenrei <= MAX_ROREI_JUKYU ;nenrei++ )
		{
			Full_Pension_Honrai_old[nendo - 2005][nenrei - UNDER_67] =  pension_marume(nendo , MARUME_NENDO ,
				Full_Pension_Honrai_Shonendo[ encho_nensu( nendo , nenrei ) ] * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] );

			Full_Pension_Tokurei_old[nendo - 2005][nenrei - UNDER_67] = pension_marume(nendo , MARUME_NENDO ,
			   	Full_Pension_Tokurei_Shonendo[ encho_nensu( nendo , nenrei ) ] * kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] );

			kaishou_check( nendo , nenrei , TOKUREI_KAISHOU_NENDO , Full_Pension_Honrai_old[nendo - 2005][nenrei - UNDER_67] , 
				Full_Pension_Tokurei_old[nendo - 2005][nenrei - UNDER_67] );

		}
	}

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = UNDER_67 ; nenrei <= MAX_ROREI_JUKYU ;nenrei++ )
		{
			Full_Pension_Honrai[nendo - SHONENDO][nenrei - UNDER_67] =  pension_marume(nendo , MARUME_NENDO ,
				Full_Pension_Honrai_Shonendo[ encho_nensu( nendo , nenrei ) ] * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] );


			Full_Pension_Tokurei[nendo - SHONENDO][nenrei - UNDER_67] = pension_marume(nendo , MARUME_NENDO ,
			   	Full_Pension_Tokurei_Shonendo[ encho_nensu( nendo , nenrei ) ] * kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] );
		}
	}

	nendo = CAL_START;

	for(nenrei = UNDER_67 ; nenrei <= MAX_ROREI_JUKYU ; nenrei++) 
	{
		kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 1.; 
		kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] = 1.;
	}

	for(nendo = CAL_START + 1 ; nendo <= SAISHUNENDO ; nendo++)
	{
		for(nenrei = UNDER_67 ; nenrei <= MAX_ROREI_JUKYU ; nenrei++)
		{
			if( nendo < TOKUREI_KAISHOU_NENDO)
			{ 
				kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67] = kaiteiritu_tokurei[nendo - ECON_SHONENDO][nenrei - UNDER_67];

			}
			else if(nendo == TOKUREI_KAISHOU_NENDO)
			{
				kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67] 
					=  Full_Pension_Honrai[nendo - SHONENDO][nenrei - UNDER_67] / Full_Pension_Tokurei_old[nendo - 1 - 2005][ max( nenrei - 1 - UNDER_67 , 0 )] ;
	
			}
			else
			{
				kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67] = kaiteiritu_honrai[nendo - ECON_SHONENDO][nenrei - UNDER_67] ;
			}

			kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]  
			 = kaiteiritu_marume( nendo , MARUME_NENDO ,
			   kaiteiritu_ruiseki[nendo - 1 - ECON_SHONENDO][max( nenrei - 1 - UNDER_67 , 0)] * kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67]);
			
			if( kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] < Kisai_Shitasasae * kaiteiritu_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67] )
			{
				kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]
				 = Kisai_Shitasasae * kaiteiritu_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];

				kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67]
				 = kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67]/ kaiteiritu_ruiseki[nendo - 1 - ECON_SHONENDO][max( nenrei - 1 - UNDER_67 ,0)];
			}
		}
	}

	for(nenrei = UNDER_67 ; nenrei <=MAX_ROREI_JUKYU ; nenrei++)
	{
		marume_saishu_nendo[nenrei - UNDER_67] = MARUME_NENDO;
		nendo = MARUME_NENDO + 1;
		
		while ( fabs( kaiteiritu_ruiseki[nendo - ECON_SHONENDO][nenrei - UNDER_67] - kaiteiritu_ruiseki[MARUME_NENDO - ECON_SHONENDO][nenrei - UNDER_67] ) < EPSILON )
		{
			marume_saishu_nendo[nenrei - UNDER_67] ++;
			nendo++;
		}
	}

	for( nendo = CAL_START + 1 ; nendo < SHONENDO ; nendo++ )
	{
		for( nenrei = 0 ; nenrei <= MAX_ROREI_JUKYU ;nenrei++ )
		{

			if( nenrei >= UNDER_67 )
			{
					
				Full_Pension_old[nendo - 2005][nenrei - UNDER_67] = Full_Pension_Tokurei_old[nendo - 2005][nenrei - UNDER_67];
			}

			Tanka_12shi = Kakyu_Tanka_12shi_Tokurei_Shonendo * kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
			Tanka_3shiiko = Kakyu_Tanka_3shiiko_Tokurei_Shonendo * kaiteiritu_tokurei_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
	
			Kakyu_Tanka_12shi_old[nendo - 2005][nenrei]  = marume_hantei(nendo , MARUME_NENDO , marume_saishu_nendo[UNDER_67 - UNDER_67] ,Tanka_12shi );		
			Kakyu_Tanka_3shiiko_old[nendo - 2005][nenrei]  = marume_hantei(nendo , MARUME_NENDO,marume_saishu_nendo[UNDER_67 - UNDER_67] ,Tanka_3shiiko );		

		}
	}

	for( nendo = SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		for( nenrei = 0 ; nenrei <= MAX_ROREI_JUKYU ;nenrei++ )
		{
			if( nenrei >= UNDER_67 )
			{
				if(nendo == 2015 )
				{
					Pension_Temp = Full_Pension_old[nendo - 1 - 2005][max(nenrei - 1 - UNDER_67 ,0)] * kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67];
	
					if(Option == 1)
					{
						Pension_Temp *= Full_Pension_Honrai_Shonendo[encho_nensu(nendo , UNDER_67)] / Full_Pension_Honrai_Shonendo[encho_nensu(nendo - 1 , UNDER_67)];
					}

					Full_Pension[nendo - SHONENDO][nenrei - UNDER_67] = marume_hantei(nendo , MARUME_NENDO,marume_saishu_nendo[nenrei - UNDER_67] ,Pension_Temp);
				}
				else
				{
					Pension_Temp = Full_Pension[nendo - 1 - SHONENDO][max(nenrei - 1 - UNDER_67 ,0)] * kaiteiritu_tannen[nendo - ECON_SHONENDO][nenrei - UNDER_67];
	
					if(Option == 1)
					{
						Pension_Temp *= Full_Pension_Honrai_Shonendo[encho_nensu(nendo , UNDER_67)] / Full_Pension_Honrai_Shonendo[encho_nensu(nendo - 1 , UNDER_67)];
					}

					Full_Pension[nendo - SHONENDO][nenrei - UNDER_67] = marume_hantei(nendo , MARUME_NENDO,marume_saishu_nendo[nenrei - UNDER_67] ,Pension_Temp);
				}
			}

			if(nendo == 2015 )
			{
				Tanka_12shi = Kakyu_Tanka_12shi_Honrai_Shonendo * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
				Tanka_3shiiko = Kakyu_Tanka_3shiiko_Honrai_Shonendo * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
			}
			else
			{
				Tanka_12shi = Kakyu_Tanka_12shi_Honrai_Shonendo * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
				Tanka_3shiiko = Kakyu_Tanka_3shiiko_Honrai_Shonendo * kaiteiritu_honrai_ruiseki[nendo - ECON_SHONENDO][UNDER_67 - UNDER_67];
			}			

				Kakyu_Tanka_12shi[nendo - SHONENDO][nenrei]  = marume_hantei(nendo , MARUME_NENDO , marume_saishu_nendo[UNDER_67 - UNDER_67] ,Tanka_12shi );		
				Kakyu_Tanka_3shiiko[nendo - SHONENDO][nenrei]  = marume_hantei(nendo , MARUME_NENDO,marume_saishu_nendo[UNDER_67 - UNDER_67] ,Tanka_3shiiko );		
		}

		for( kubun = 0 ; kubun < SHIBOU_KUBUN ; kubun++ )
		{
			Tanka_Shibou[nendo - SHONENDO][kubun] = Tanka_Shibou_Shonendo[kubun];
		}
	}

	index_out( fp_out[INDEX] , cpi_up , base_up , cpi_up_index ,base_up_index ,kaiteiritu_honrai , kaiteiritu_tokurei ); 

	kaitei_out( fp_out[HONRAI_PENSION]  , kaiteiritu_honrai , CAL_START , ECON_SHONENDO , SAISHUNENDO , "Nz藦i{j" ); 
	kaitei_out( fp_out[HONRAI_PENSION]  , kaiteiritu_honrai_ruiseki , CAL_START , ECON_SHONENDO , SAISHUNENDO ,"ݐω藦i{j" ); 
	kaitei_out( fp_out[HONRAI_PENSION]     , Full_Pension_Honrai , SHONENDO , SHONENDO , SAISHUNENDO ,"bNPi{j" ); 


	kaitei_out( fp_out[TOKUREI_PENSION] , kaiteiritu_tokurei , CAL_START , ECON_SHONENDO , SAISHUNENDO ,"Nz藦iᐅj" ); 
	kaitei_out( fp_out[TOKUREI_PENSION] , kaiteiritu_tokurei_ruiseki , CAL_START , ECON_SHONENDO , SAISHUNENDO ,"ݐω藦iᐅj" ); 
	kaitei_out( fp_out[TOKUREI_PENSION]    , Full_Pension_Tokurei , SHONENDO , SHONENDO , SAISHUNENDO , "bNPiᐅj" ); 

	kaitei_out( fp_out[REAL_PENSION]    , kaiteiritu_tannen , CAL_START , ECON_SHONENDO , SAISHUNENDO ,"Nz藦iŏIj" ); 
	kaitei_out( fp_out[REAL_PENSION]    , kaiteiritu_ruiseki , CAL_START , ECON_SHONENDO , SAISHUNENDO ,"ݐω藦iŏIj" ); 
	kaitei_out( fp_out[REAL_PENSION]       , Full_Pension , SHONENDO , SHONENDO , SAISHUNENDO , "bNPiŏIj" ); 


	kakyu_out( fp_out[REAL_PENSION]        , Kakyu_Tanka_12shi   , SHONENDO , SHONENDO , SAISHUNENDO , "PiPEQqj" ); 
	kakyu_out( fp_out[REAL_PENSION]        , Kakyu_Tanka_3shiiko , SHONENDO , SHONENDO , SAISHUNENDO , "PiRqȍ~j" ); 

	ichijikin_out(fp_out[REAL_PENSION] , Tanka_Shibou , SHONENDO , SHONENDO , SAISHUNENDO ,"SꎞP");

	rslt_out( fp_out[KAITEI] , kaiteiritu_tannen , CAL_START + 1 , ECON_SHONENDO , SAISHUNENDO); 

}

double round( double a , int n )
{
 	double b;
 	char buf[256] = {'\0'};
 	char *p;
	
	sprintf( buf , "%.*f" , n , a );
	b = strtod( buf , &p );
	
	return b;
}

double pension_marume( int nendo , int marume_nendo , double a )
{	
	double b;

	if (nendo <= marume_nendo)
	{
		b = floor( ( a + 50. ) / 100. ) * 100;
	}
	else
	{
		b = a;
	}
	
	return b;
}


double kaiteiritu_marume( int nendo ,int marume_nendo , double a)
{
	if(nendo <= marume_nendo)
	{
		a = round(a , 3);
	}

	return a;

}


void econ_read(FILE *fp , double cpi_up[] , double base_up[])
{
	int counter;
	int data_number;
	double buffer[16];
	int nendo;

	while ( ( read_data( buffer , fp , &data_number ) != EOF ) )
	{
		nendo = (int)( buffer[0] ) + 2000;
		cpi_up[nendo - ECON_SHONENDO] = 1. + buffer[6] / 100.;
		base_up[nendo - ECON_SHONENDO] = 1. + buffer[4] / 100.;
	}
	

	for( counter = nendo + 1 ; counter <= SAISHUNENDO ; counter++ )
	{
		cpi_up[counter - ECON_SHONENDO] = cpi_up[nendo - ECON_SHONENDO];
		base_up[counter - ECON_SHONENDO] = base_up[nendo - ECON_SHONENDO];
	}

	return ;

}


void index_make(double base_up[] , double cpi_up[] , double base_up_index[] , double cpi_up_index[] , int marume_nendo)
{
	int HIKIAGE_START = 2003;
	int HIKIAGE_END = 2017;
	int nendo;

	double HOKENRYO[ 2017 - 2003 + 1 ]
		= { 0.1358 ,0.13934 , 0.14288 , 0.14642 , 0.14996 , 0.1535 , 0.15704 , 0.16058 , 0.16412 , 0.16766 , 0.1712 , 0.17474 , 0.17828 , 0.18182 , 0.183 };

	double  KASYOBUN_START = 0.910;

	double kashobun_henka[SAISHUNENDO - ECON_SHONENDO + 1];
	double base_up_real[SAISHUNENDO - ECON_SHONENDO + 1];
	double base_up_avg[SAISHUNENDO - ECON_SHONENDO + 1];

	for( nendo = ECON_SHONENDO ; nendo <= SAISHUNENDO ; nendo++ )
	{
		base_up_real[nendo - ECON_SHONENDO] = base_up[nendo - ECON_SHONENDO] / cpi_up[nendo - ECON_SHONENDO];
	}

	for( nendo = ECON_SHONENDO + 4 ; nendo <= SAISHUNENDO ; nendo++ )
	{
		if( nendo == 2005 || nendo == 2006 )
		{
			base_up_avg[nendo - ECON_SHONENDO] = 1.;
			kashobun_henka[nendo - ECON_SHONENDO] = 1.;
		}
		else 
		{
			base_up_avg[nendo - ECON_SHONENDO]
	 		 = base_up_real[nendo - 4 - ECON_SHONENDO] * base_up_real[nendo - 3 - ECON_SHONENDO] * base_up_real[nendo - 2 - ECON_SHONENDO];

			base_up_avg[nendo - ECON_SHONENDO] = pow( base_up_avg[nendo - ECON_SHONENDO] , 1. / 3. );

			if(nendo < HIKIAGE_END + 4)
			{
				kashobun_henka[nendo - ECON_SHONENDO] = ( ( KASYOBUN_START - HOKENRYO[nendo - 3 -HIKIAGE_START] / 2. ) 
										/ ( KASYOBUN_START - HOKENRYO[nendo - 4 - HIKIAGE_START] / 2. ) );
			}
			else
			{
				kashobun_henka[nendo - ECON_SHONENDO] = 1.;
			}
		}

		base_up_avg[nendo - ECON_SHONENDO] = kaiteiritu_marume( nendo , marume_nendo , base_up_avg[nendo - ECON_SHONENDO]);
		kashobun_henka[nendo - ECON_SHONENDO] = kaiteiritu_marume( nendo , marume_nendo , kashobun_henka[nendo - ECON_SHONENDO]);

	}
	
	for( nendo = ECON_SHONENDO + 4 ; nendo <= SAISHUNENDO ; nendo++ )
	{
		base_up_index[nendo - ECON_SHONENDO]
			= cpi_up[nendo - 1 - ECON_SHONENDO] * kashobun_henka[nendo - ECON_SHONENDO] * base_up_avg[nendo - ECON_SHONENDO];
		cpi_up_index[nendo - ECON_SHONENDO] = cpi_up[nendo - 1 - ECON_SHONENDO];

		base_up_index[nendo - ECON_SHONENDO] = kaiteiritu_marume( nendo , marume_nendo , base_up_index[nendo - ECON_SHONENDO] );
		cpi_up_index[nendo - ECON_SHONENDO] = kaiteiritu_marume( nendo , marume_nendo ,cpi_up_index[nendo - ECON_SHONENDO] );

	}

	return ;

}

double honrai_kaiteiritu_make_before(int nenrei , double base_up_index , double cpi_up_index) 
{
	double kaiteiritu;

	if(nenrei == UNDER_67)
	{
		if( base_up_index < 1. && base_up_index < cpi_up_index )
		{
			if(cpi_up_index > 1.)
			{
				kaiteiritu = 1.;
			}
			else
			{
				kaiteiritu = cpi_up_index;
			}
		}
		else
		{
			kaiteiritu = base_up_index;
		}
	}
	else
	{
		if( cpi_up_index > base_up_index && base_up_index >= 1. )
		{
			kaiteiritu = base_up_index;
		}
		else if( cpi_up_index > 1.&&  base_up_index < 1.)
		{
			kaiteiritu = 1.;
		}
		else
		{
			kaiteiritu = cpi_up_index;
		}
	}

	return kaiteiritu;

}


double honrai_kaiteiritu_make(int nenrei , double base_up_index , double cpi_up_index) 
{
	double kaiteiritu;

	if(nenrei == UNDER_67)
	{
		kaiteiritu = base_up_index;
	}
	else
	{
		if(cpi_up_index > base_up_index)
		{
			kaiteiritu = base_up_index;
		}
		else
		{
			kaiteiritu = cpi_up_index;
		}
	}

	return kaiteiritu;
}


double tokurei_kaiteiritu_make(int nendo)
{
	double kaiteiritu[] = {1.000 ,0.997 ,1.000 ,1.000 ,1.000 ,1.000 ,0.996 ,0.997 ,0.990 ,0.993 ,0.000 };

	return kaiteiritu[nendo - 2005]; 
}


int kaishou_check(int nendo , int nenrei ,int kaishou_nendo  , double full_pension_honrai , double full_pension_tokurei)
{
	if( nendo < kaishou_nendo)
	{
		if( full_pension_honrai > full_pension_tokurei)
		{
			printf("%dNx%d΂̓ᐅĂ܂B({F%20.0e , ᐅF%20.0e)\n", nendo , nenrei , full_pension_honrai , full_pension_tokurei);
			exit(1);
		}
	}
	else
	{
		if( full_pension_honrai < full_pension_tokurei)
		{
			printf("%dNx%d΂̓ᐅĂ܂B({F%20.0e , ᐅF%20.0e)\n", nendo , nenrei ,full_pension_honrai , full_pension_tokurei);
			exit(1);
		}
	}

	return 0;

}


double marume_hantei(int nendo ,int marume_nendo , int marume_saishu_nendo ,double pension)
{

	double a;

	if(nendo <= marume_nendo)
	{
		a = pension_marume( nendo , marume_nendo , pension );
	}
	else if( nendo <= marume_saishu_nendo)
	{
		a = max( pension , pension_marume( nendo , marume_nendo , pension ) );
	}
	else
	{
		a = pension;
	}

	return a;
}



void index_out( FILE *fp ,double cpi_up[] , double base_up[] , double cpi_up_index[] ,double base_up_index[] , double kaiteiritu_honrai[][MAX_ROREI_JUKYU - UNDER_67 + 1] , double kaiteiritu_tokurei[][MAX_ROREI_JUKYU - UNDER_67 + 1])
{
	char *head[8] = {"Nxi2j","㏸","㏸","CfbNX","CfbNX","藦i{EVفj","藦i{Eفj","藦iᐅj"};
	int nendo;
	int i;

	fprintf(fp,"%s",head[0]);

	for (i = 1 ; i < 8 ; i++)
	{
		fprintf(fp,",%s",head[i]);
	}

	fprintf(fp,"\n");
	
	for (nendo = ECON_SHONENDO ;nendo <=SAISHUNENDO ;nendo++)
	{ 
		fprintf(fp,"%d,%20.14e,%20.14e,%20.14e,%20.14e,%20.14e,%20.14e,%20.14e\n",nendo - 2000 , cpi_up[nendo-ECON_SHONENDO] ,base_up[nendo-ECON_SHONENDO],
			cpi_up_index[nendo-ECON_SHONENDO] , base_up_index[nendo-ECON_SHONENDO] ,kaiteiritu_honrai[nendo-ECON_SHONENDO][UNDER_67 - UNDER_67],
			kaiteiritu_honrai[nendo-ECON_SHONENDO][UNDER_67 + 1 - UNDER_67] , kaiteiritu_tokurei[nendo-ECON_SHONENDO][UNDER_67 - UNDER_67] );
	}

	return ;

}


void kaitei_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU - UNDER_67 + 1] , int shonendo , int array_shonendo , int saishunendo ,char *title )  

{
	int nenrei;

	fprintf(fp , "%s\n%s",title,"Nxi2j");

	for (nenrei= UNDER_67 ;nenrei <= MAX_ROREI_JUKYU ;nenrei++)
	{
		fprintf(fp , ",%d",nenrei);
	}

	fprintf(fp , "\n");

	rslt_out(fp , output_array , shonendo , array_shonendo , saishunendo );

	return ;

}


void rslt_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU - UNDER_67 + 1] , int shonendo , int array_shonendo , int saishunendo )
{
	int nendo;
	int nenrei;

	for( nendo = shonendo ; nendo <= saishunendo ; nendo++ )
	{

		fprintf(  fp , "%d," ,  nendo - 2000 ); 

		for( nenrei = UNDER_67 ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
		{
			fprintf(  fp , "%20.14e," , output_array[nendo - array_shonendo][nenrei - UNDER_67]);
		}

		fprintf(  fp , "\n" );
	}
	
	return ;

}


void kakyu_out( FILE *fp , double output_array[][MAX_ROREI_JUKYU + 1] , int shonendo , int array_shonendo , int saishunendo  , char *title )
{
	int nendo;
	int nenrei;

	fprintf(fp , "%s\n%s",title,"Nxi2j");

	for (nenrei= 0 ;nenrei <= MAX_ROREI_JUKYU ;nenrei++)
	{
		fprintf(fp , ",%d",nenrei);
	}

	fprintf(fp , "\n");


	for( nendo = shonendo ; nendo <= saishunendo ; nendo++ )
	{

		fprintf(  fp , "%d," ,  nendo - 2000 ); 

		for( nenrei = 0 ; nenrei <= MAX_ROREI_JUKYU ; nenrei++ )
		{
			fprintf(  fp , "%20.14e," , output_array[nendo - array_shonendo][nenrei]);
		}

		fprintf(  fp , "\n" );
	}
	
	return ;

}


void ichijikin_out( FILE *fp , double shibou[][SHIBOU_KUBUN]  ,int shonendo , int array_shonendo , int saishunendo , char *title)
{
	char *ichijikin_kubun[]={ "6ȏ180" , "180ȏ240" , "240ȏ300" , "300ȏ360" , "360ȏ420" , "420ȏ" };
	int kubun;
	int nendo;	

	fprintf(fp , "%s\n%s",title,"Nxi2j");

	for(kubun = 0 ;kubun < SHIBOU_KUBUN ; kubun++)
	{
		fprintf(  fp , ",%s" , ichijikin_kubun[kubun]);
	}

	fprintf(fp , "\n");



	for (nendo = shonendo ; nendo <= saishunendo ; nendo++)
	{
		fprintf(  fp , "%d," , nendo - 2000);
		
		for(kubun = 0 ;kubun < SHIBOU_KUBUN ; kubun++)
		{
			fprintf(  fp , "%20.14e," , shibou[nendo - array_shonendo][kubun]);
		}

		fprintf(fp , "\n");
	}

	return;
}

